<?php

//Test

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Models\ServiceQrModel;
use App\Models\AssignServiceModel;
use Illuminate\Support\Facades\DB;
use App\Models\OrderModel;
use App\Models\CartModel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Crypt;
use App\Models\BookingItemModel;
use App\Models\StateAdminModel;
use App\Models\MaintenanceCategoryModel;
use App\Models\MaintenanceSubCategoryModel;
use App\Models\MaintenanceModel;
use App\Models\SupportTicketCommentsModel;
use App\Models\MaintenanceLogsModel;

use App\Models\ProjectModel;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
class SupportTicketController extends Controller
{
    
public function supportTicketUnits()
{
    try {
        $units = ServiceQrModel::all();
        $allunits=[];
        foreach($units as $unit){
            $allunits[]=[
              'unitid' => $unit->id,
              'unitname' => $unit->qrcodeId,
            ];
        }

        return response()->json([
            'status'  => 'success',
            'message' => 'Units retrieved successfully',
            'data'    => $allunits
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}

public function supportTicketcategory()
{
    try {
        $categories = MaintenanceCategoryModel::all();
        $allcategories=[];
        foreach($categories as $cat){
            $allcategories[]=[
              'categoryid' => $cat->id,
              'categoryname' => $cat->m_category,
            ];
        }

        return response()->json([
            'status'  => 'success',
            'message' => 'Categories retrieved successfully',
            'data'    => $allcategories
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}
public function supportTicketprojects()
{
    try {
        $projects = ProjectModel::all();
        $allprojects=[];
        foreach($projects as $project){
            $allprojects[]=[
              'projectid' => $project->id,
              'projectname' => $project->project,
            ];
        }

        return response()->json([
            'status'  => 'success',
            'message' => 'Projects retrieved successfully',
            'data'    => $allprojects
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}
public function supportTicketsubcategories(Request $request)
{
    try {
        $subCats = MaintenanceSubCategoryModel::where('mcat_id', $request->mcatid)->get();

        $allsubcats = [];
        foreach($subCats as $sub) {
            $allsubcats[] = [
                'subcategoryid'   => $sub->id,
                'subcategoryname' => $sub->sub_cat,
            ];
        }

        return response()->json([
            'status'  => 'success',
            'message' => 'Sub Categories retrieved successfully',
            'data'    => $allsubcats
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}

public function storeSupportTicket(Request $request)
{
    try {

        date_default_timezone_set('Asia/Kolkata');

    
        // AUTO CASE ID
        $maxId = MaintenanceModel::max('case_id');
        $newCaseId = ($maxId) ? $maxId + 1 : 100;
        //    return response()->json([
        //     'status' => 'success',
        //     'unit' => $request->unit,
          
            
        // ], 200);

        // DATA
        $data = [
            'case_id'       => $newCaseId,
            'posted_date'   => $request->filled('mdate')
                ? \Carbon\Carbon::parse($request->mdate)->format('Y-m-d H:i:s')
                : now(),
            'state_id'      => 1,
            'district_id'   => 1,
            'unit_id'       => $request->unit,
            'mcat_id'       => $request->categoryid,
            'projectid'     => $request->projectid,
            'subcat_id'     => $request->subcategoryid,
            'priority'      => $request->priority,
            'subject'       => $request->subject,
            'description'   => $request->description,
            'comment'       => $request->comment,
            'posted_by'     => $request->userid,
        ];

        // MULTIPLE IMAGE UPLOAD
        if ($request->hasFile('attachments')) {

            $files = [];

            foreach ($request->file('attachments') as $file) {

                $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('images/maintenance'), $filename);

                $files[] = $filename;
            }

            $data['cashier_imgs'] = json_encode($files);
        }

        // CREATE ENTRY
        $maintenance = MaintenanceModel::create($data);

        return response()->json([
            'status' => 'success',
            'message' => 'Support Ticket created successfully',
            'maintenance_data' => $maintenance
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status' => 'error',
            'message' => 'Something went wrong',
            'error' => $e->getMessage()
        ], 500);
    }
}

public function viewSupportTicket(Request $request)
{
              return response()->json([
            "status"  => true,
            "message" => "Ticket details fetched successfully",
            "data"    => "hi"
        ], 200);
         
    try {

        $ticket = MaintenanceModel::leftJoin('state_service', 'state_service.id', '=', 'Maintenance.state_id')
            ->leftJoin('district_srvice', 'district_srvice.id', '=', 'Maintenance.district_id')
            ->leftJoin('servisesqr', 'servisesqr.id', '=', 'Maintenance.unit_id')
            ->leftJoin('maintenance_category', 'maintenance_category.id', '=', 'Maintenance.mcat_id')
            ->leftJoin('sub_category_maintenance', 'sub_category_maintenance.id', '=', 'Maintenance.subcat_id')
            ->leftJoin('users', 'users.id', '=', 'Maintenance.posted_by')
            ->leftJoin('projects','projects.id','=','Maintenance.projectid')
            ->select(
                'Maintenance.*',
                'state_service.state_name',
                'district_srvice.district_name',
                'servisesqr.qrcodeId',
                'maintenance_category.m_category',
                'sub_category_maintenance.sub_cat',
                'users.name as created_by',
                'projects.project'
            )
            ->where('Maintenance.id', $request->main_id)
            ->first();

        if (!$ticket) {
            return response()->json([
                "status" => false,
                "message" => "Ticket not found"
            ], 404);
        }

        // =======================
        // COMMENTS
        // =======================
       


    $comments = SupportTicketCommentsModel::where('ticket_id', $request->main_id)
    ->orderBy('id', 'desc')
    ->get();


        


        // =======================
        // LOGS
        // =======================
            $logs = MaintenanceLogsModel::leftJoin('users', 'users.id', '=', 'maintenance_logs.user_id')
            ->where('maintenance_logs.record_id', $request->main_id) // ticket id
            ->orderBy('maintenance_logs.created_at', 'desc')
            ->select(
                'maintenance_logs.*',
                'users.name as user_name'
            )
            ->get();

        // =======================
        // ATTACHMENTS
        // =======================
        $beforeImages = $ticket->cashier_imgs 
            ? json_decode($ticket->cashier_imgs, true) 
            : [];

        $afterImages = $ticket->supervisor_imgs 
            ? json_decode($ticket->supervisor_imgs, true) 
            : [];

        // =======================
        // RESPONSE FORMAT
        // =======================
        $data = [
            "case_id"      => $ticket->case_id,
            "status"       => $ticket->resolved_status,
            "priority"     => $ticket->priority,
            "category"     => $ticket->m_category,
            "subcategory"  => $ticket->sub_cat,
            "project"      => $ticket->project,
            "unit_no"      => $ticket->qrcodeId,
            "created_by"   => $ticket->created_by,
            "created_on"   => $ticket->created_at,
            "subject"      => $ticket->subject,
            "description"  => $ticket->description,
            "before_images"=> $beforeImages,
            "after_images" => $afterImages,
            "comments"     => $comments,
            "logs"         => $logs
        ];

        return response()->json([
            "status"  => true,
            "message" => "Ticket details fetched successfully",
            "data"    => $data
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            "status"  => false,
            "message" => "Something went wrong",
            "error"   => $e->getMessage()
        ], 500);
    }
}


// public function viewSupportTicket($id)
// {
//     try {

//       $ticket = MaintenanceModel::select(
//             'Maintenance.*',
//             'users.name as created_by',
//             'servisesqr.qrcodeId',
//             'maintenance_category.m_category',
//             'sub_category_maintenance.sub_cat',
//             'projects.project',
//             'state_service.state_name',
//             'district_srvice.district_name'
//         )
//         ->leftJoin('users', 'users.id', '=', 'Maintenance.posted_by')
//         ->leftJoin('servisesqr', 'servisesqr.id', '=', 'Maintenance.unit_id')
//         ->leftJoin('maintenance_category', 'maintenance_category.id', '=', 'Maintenance.mcat_id')
//         ->leftJoin('sub_category_maintenance', 'sub_category_maintenance.id', '=', 'Maintenance.subcat_id')
//         ->leftJoin('projects', 'projects.id', '=', 'Maintenance.projectid')
//         ->leftJoin('state_service','state_service.id','=','Maintenance.state_id')
//         ->leftJoin('district_srvice','district_srvice.id','=','Maintenance.district_id')
//         ->where('Maintenance.id', $id)
//         ->first();

//     if (!$ticket) {
//         return response()->json([
//             'status' => false,
//             'message' => 'Ticket not found'
//         ], 404);
//     }
//         // =======================
//         // TICKET AGE
//         // =======================
//         $created = \Carbon\Carbon::parse($ticket->created_at);
//         $now     = \Carbon\Carbon::now();
//         $days    = $created->diffInDays($now);
//         $hours   = $created->copy()->addDays($days)->diffInHours($now);

//         // =======================
//         // CLEAN ATTACHMENTS
//         // =======================
//         $beforeImages = $ticket->cashier_imgs ? json_decode($ticket->cashier_imgs, true) : [];
//         $afterImages  = $ticket->supervisor_imgs ? json_decode($ticket->supervisor_imgs, true) : [];


//         // =======================
//         // RESPONSE
//         // =======================
//         $data = [

//             "case_id"       => $ticket->case_id,

//             // -------- STATUS ----------
//             "status_code"   => $ticket->resolved_status,
//             "status_text"   => match($ticket->resolved_status) {
//                 '2' => "Resolved",
//                 '1' => "WIP",
//                 '5' => "Awaited",
//                 '4' => "Hold",
//                 '3' => "Closed",
//                 '0' => "New"
//             },

//             // -------- PRIORITY ----------
//             "priority_code" => $ticket->priority,
//             "priority_text" => match($ticket->priority) {
//                 '1' => "Low",
//                 '2' => "Medium",
//                 '3' => "High",
                
//             },

//             "category"      => $ticket->m_category,
//             "subcategory"   => $ticket->sub_cat,
//             "assigned_to"   => $ticket->assigned_to,
//             "unit_no"       => $ticket->qrcodeId,
//             "project"       => $ticket->project,
//             "created_by"    => $ticket->name,
//             "created_on"    => $ticket->created_at ? $ticket->created_at->format("d-m-y H:i") : null,
//             "modified_on"   => $ticket->updated_at ? $ticket->updated_at->format("d-m-y H:i") : null,
//             "resolved_on"   => ($ticket->resolved_status == 2 && $ticket->updated_at)
//                                 ? $ticket->updated_at->format("d-m-y H:i")
//                                 : null,
//             "follow_up"     => ($ticket->follow_up && $ticket->follow_up != "-")
//                                 ? \Carbon\Carbon::parse($ticket->follow_up)->format("d-m-y H:i")
//                                 : "-",
//             "ticket_age"    => $days . "d, " . $hours . "h",

//             "linked_ticket" => $ticket->link_tkt,

//             "subject"       => $ticket->subject,
//             "description"   => $ticket->description,

      

//             "comment_updates"    => $ticket->supervisor_comment,
//             "resolution_comment" => $ticket->resolution_comment,
//         ];

//         return response()->json([
//             "status"  => true,
//             "message" => "Ticket details fetched",
//             "ticket"  => $data
//         ], 200);

//     } catch (\Exception $e) {

//         return response()->json([
//             "status"  => false,
//             "message" => "Something went wrong",
//             "error"   => $e->getMessage()
//         ], 500);
//     }
// }


public function editSupportTicket(Request $request)
{
    try {

        $ticket = MaintenanceModel::select(
            'Maintenance.id as maintenance_id',
            'Maintenance.case_id',
            'Maintenance.state_id',
            'Maintenance.district_id',
            'Maintenance.unit_id',
            'Maintenance.projectid',
            'Maintenance.mcat_id',
            'Maintenance.subcat_id',
            'Maintenance.priority',
            'Maintenance.resolved_status',
            'Maintenance.assigned_to',
            'Maintenance.subject',
            'Maintenance.description',
            'Maintenance.follow_up',
            'Maintenance.link_tkt',
            'Maintenance.supervisor_comment',
            'Maintenance.resolution_comment',
            'Maintenance.created_at',
            'Maintenance.updated_at',

            'users.name as created_by',
            'servisesqr.qrcodeId as unit_no',
            'state_service.state_name',
            'district_srvice.district_name',
            'projects.project',
            'maintenance_category.m_category',
            'sub_category_maintenance.sub_cat'
        )
        ->leftJoin('users', 'users.id', '=', 'Maintenance.posted_by')
        ->leftJoin('servisesqr', 'servisesqr.id', '=', 'Maintenance.unit_id')
        ->leftJoin('state_service','state_service.id','=','Maintenance.state_id')
        ->leftJoin('district_srvice','district_srvice.id','=','Maintenance.district_id')
        ->leftJoin('projects','projects.id','=','Maintenance.projectid')
        ->leftJoin('maintenance_category', 'maintenance_category.id', '=', 'Maintenance.mcat_id')
        ->leftJoin('sub_category_maintenance', 'sub_category_maintenance.id', '=', 'Maintenance.subcat_id')
        ->where('Maintenance.id', $request->main_id)
        ->first();

        if (!$ticket) {
            return response()->json([
                'status'  => false,
                'message' => 'Ticket not found'
            ], 404);
        }

        $data = [
            "case_id"      => $ticket->case_id,
            "state_id"     => $ticket->state_id,
            "district_id"  => $ticket->district_id,
            "unit_id"      => $ticket->unit_id,
            "projectid"    => $ticket->projectid,
            "mcat_id"      => $ticket->mcat_id,
            "subcat_id"    => $ticket->subcat_id,
            "priority"     => $ticket->priority,
            "status"       => $ticket->resolved_status,
            "assigned_to"  => $ticket->assigned_to,
            "linked_ticket"=> $ticket->link_tkt,
            "follow_up"    => $ticket->follow_up,
            "subject"      => $ticket->subject,
            "description"  => $ticket->description,
            "comment"      => $ticket->supervisor_comment,
            "resolution"   => $ticket->resolution_comment
        ];

        return response()->json([
            'status'  => true,
            'message' => 'Edit ticket fetched successfully',
            'data'    => $data
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status'  => false,
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}

public function updateSupportTicket(Request $request, $id)
{
    $ticket = MaintenanceModel::where('id', $id)->first();

    if (!$ticket) {
        return response()->json([
            'status' => false,
            'message' => 'Ticket not found'
        ], 404);
    }

    $ticket->priority      = $request->priority ?? $ticket->priority;
    $ticket->description   = $request->description ?? $ticket->description;
    $ticket->mcat_id       = $request->mcat_id ?? $ticket->mcat_id;
    $ticket->subcat_id     = $request->subcat_id ?? $ticket->subcat_id;
    $ticket->assigned_to   = $request->assigned_to ?? $ticket->assigned_to;
    $ticket->follow_up     = $request->follow_up ?? $ticket->follow_up;
    $ticket->link_tkt      = $request->link_tkt ?? $ticket->link_tkt;
    $ticket->resolved_status = $request->resolved_status ?? $ticket->resolved_status;
    $ticket->resolution_comment = $request->resolution_comment ?? $ticket->resolution_comment;

    // If attachments uploaded (Before)
    if ($request->hasFile('before_attachments')) {
        $beforeList = [];
        foreach($request->file('before_attachments') as $img) {
            $filename = time(). rand(1000,9999) . "." . $img->getClientOriginalExtension();
            $img->move(public_path('images/maintenance/'), $filename);
            $beforeList[] = $filename;
        }
        $ticket->cashier_imgs = json_encode($beforeList);
    }

    // If attachments uploaded (After)
    if ($request->hasFile('after_attachments')) {
        $afterList = [];
        foreach($request->file('after_attachments') as $img) {
            $filename = time(). rand(1000,9999) . "." . $img->getClientOriginalExtension();
            $img->move(public_path('images/maintenance/'), $filename);
            $afterList[] = $filename;
        }
        $ticket->supervisor_imgs = json_encode($afterList);
    }

    $ticket->save();

    return response()->json([
        'status' => true,
        'message' => 'Ticket updated successfully',
        'data' => $ticket
    ]);
}


}
