<?php

//Test

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Models\ServiceQrModel;
use App\Models\AssignServiceModel;
use Illuminate\Support\Facades\DB;
use App\Models\OrderModel;
use App\Models\CartModel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Crypt;
use App\Models\BookingItemModel;
use App\Models\StateAdminModel;
use App\Models\CustomerModel;
use App\Models\otpmodel;
use App\Models\MembershipCustomerModel;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
class UnitServiceController extends Controller
{
    // Public function allUnits(){
	//  return response()->json([
    //         'message' => 'Hello, this is an example API response!',
    //         'status' => 'success',
    //     ]);
	// }

    public function allUnits(): JsonResponse
    {
           try {

        /* 1️⃣  बेस क्वेरी – सिर्फ़ ज़रूरी कॉलम  */
        $query = ServiceQrModel::select(
            'id',
            'qrcodeId',
            'unit_img',
            'unit_location',
            'open_timing'
        );

        /* 2️⃣  कस्टमर यूज़र चेक + रोल 3 फ़िल्टर  */
        if ($user = auth('customer')->user()) {
            if ($user->role == 3 && $user->unitId) {
                $query->where('qrcodeId', $user->unitId);
            }
        }

        /* 3️⃣  डेटा खींचें  */
        $units = $query->get();

        if ($units->isEmpty()) {
            return response()->json([
                'status'  => 'success',
                'message' => 'No units found',
                'data'    => [],
            ], 200);
        }

        /* 4️⃣  कलेक्शन → पेलोड  */
        $data = $units->map(fn ($u) => [
            'Id'            => $u->id,
            'Unit_Id'       => $u->qrcodeId,
            'Unit_Image'    => 'https://testenv.magnetconnects.com/public/images/Qrcodes/'.$u->unit_img,
            'Unit_location' => $u->unit_location,
            'timing'        => $u->open_timing,
        ]);

        /* 5️⃣  रिस्पॉन्स  */
        return response()->json([
            'status'  => 'success',
            'message' => 'Units retrieved successfully',
            'data'    => $data,
        ], 200);

    } catch (\Throwable $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => app()->environment('production')
                         ? 'Internal server error'
                         : $e->getMessage(),
        ], 500);
    }
    }

//     public function getServicesByUnit(Request $request): JsonResponse
//     {
    

//         try {
      
//             $assignedServices = AssignServiceModel::join('servises','assignservice.serviceId','servises.id')->select(
//                         'assignservice.id',
//                         'assignservice.serviceId',
//                         'assignservice.assqrcodeId',
//                         'assignservice.price',
//                         'assignservice.uses',
//                         'servises.services_name')
                   
//                     ->where('assignservice.assqrcodeId', $request->unit_id)
// 				->where('assignservice.paytype', $request->service_type)
// 				  ->where('assignservice.mem_status', 0)
//                     ->get();



    
//             // Check if data exists
//             if ($assignedServices->isEmpty()) {
//                 return response()->json([
//                     'status' => 'error',
//                     'message' => 'No services found',
//                     'data' => []
//                 ], 404);
//             }

//             // Format data with custom key-value structure
// $allServices = [];
// foreach ($assignedServices as $service) {
//     $allServices[] = [
//         'Assign_Service_Id' => $service->id,
//         'Service_ID' => $service->serviceId,
//         'Unit_id' => $service->assqrcodeId,
//         'Service_Name' => $service->services_name,
//         'Price' => $service->price,
//         'Usage_Duration' => $service->uses
//     ];
// }
    
//             // Return Response
//             return response()->json([
//                 'status' => 'success',
//                 'message' => 'services retrieved successfully',
//                 'data' => $allServices
//             ], 200);
    
//         } catch (\Exception $e) {
//             // Handle Error
//             return response()->json([
//                 'status' => 'error',
//                 'message' => 'Something went wrong',
//                 'error' => $e->getMessage()
//             ], 500);
//         }
//     }

public function getServicesByUnit(Request $request): JsonResponse
{
    try {

        // Logged-in customer (if any)
        $customer = Auth::guard('customer')->user();
        $identifier = $customer ? $customer->id : $request->session()->getId();

        // API Input
        $unit_id     = $request->unit_id;
        $paytype     = $request->service_type ?? 1; 
        $mem_status  = $request->mem_status ?? 0;

        // From customer login
        $role = $customer->role ?? null;

        // Base Query
        $query = AssignServiceModel::join('servises', 'assignservice.serviceId', '=', 'servises.id')
            ->join('servisesqr', 'assignservice.assqrcodeId', '=', 'servisesqr.qrcodeId')
            ->leftJoin('cart_tbl', function ($join) use ($identifier) {
                $join->on('assignservice.id', '=', 'cart_tbl.Assign_service_id')
                    ->where('cart_tbl.session_id', '=', $identifier);
            })
            ->where('assignservice.assqrcodeId', $unit_id)
            ->where('assignservice.status', '1');

        // =============== ROLE BASED CONDITIONS (exact copy from web code) =================
        $query->when($role == 2, function ($q) {
            // Customer → online services only, mem_status = 0
            $q->where('assignservice.paytype', 2)
              ->where('assignservice.mem_status', 0);
        });

        $query->when($role == 11, function ($q) {
            // Membership → online membership services only
            $q->where('assignservice.paytype', 2)
              ->where('assignservice.mem_status', 1);
        });

        $query->when($role == 3, function ($q) use ($mem_status, $paytype) {
            // Super admin role: take API input based filters
            $q->where('assignservice.paytype', $paytype)
              ->where('assignservice.mem_status', $mem_status);
        });

        // Select
        $assignedServices = $query->select(
                'assignservice.id',
                'assignservice.serviceId',
                'assignservice.assqrcodeId',
                'assignservice.price',
                'assignservice.uses',
                'assignservice.order_display',
                'servises.services_name',
                'servises.img_icon',
                'servisesqr.unit_location',
                DB::raw('COALESCE(cart_tbl.quantity, 0) as cart_qnty')
            )
            ->orderBy(DB::raw('CAST(assignservice.order_display AS UNSIGNED)'))
            ->get();

        // No data
        if ($assignedServices->isEmpty()) {
            return response()->json([
                'status' => 'error',
                'message' => 'No services found',
                'data' => []
            ], 404);
        }

        // Format API response
        $result = $assignedServices->map(function ($service) {
            return [
                'Assign_Service_Id' => $service->id,
                'Service_ID'        => $service->serviceId,
                'Unit_Id'           => $service->assqrcodeId,
                'Service_Name'      => $service->services_name,
                'Price'             => $service->price,
                'Usage_Duration'    => $service->uses,
                'Image'             => $service->img_icon,
                'Unit_Location'     => $service->unit_location,
                'Cart_Quantity'     => $service->cart_qnty
            ];
        });

        // Final JSON
        return response()->json([
            'status' => 'success',
            'message' => 'Services retrieved successfully',
            'data' => $result
        ], 200);

    } catch (\Exception $e) {
        // Unexpected Error
        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}




//     public function initiateBooking(Request $request): JsonResponse
// {
//     $data = $request->json()->all();

//     try {
//         DB::beginTransaction();

//         // Generate Unique Booking ID
//         $currentYear = date('Y');
//         $currentMonth = date('m');

//         $lastBooking = OrderModel::where('booking_id', 'LIKE', "B{$currentYear}{$currentMonth}%")
//             ->orderBy('id', 'desc')
//             ->first();

//         $lastNumber = $lastBooking && preg_match('/B\d{6}(\d+)/', $lastBooking->booking_id, $matches)
//             ? (int)$matches[1]
//             : 0;

//         $nextNumber = $lastNumber + 1;
//         $numberLength = max(6, strlen($nextNumber));
//         $newbookingId = "B" . $currentYear . $currentMonth . str_pad($nextNumber, $numberLength, '0', STR_PAD_LEFT);

       
//         $encriptedBkID = substr(hash('sha256', $newbookingId), 0, 16);
//         // return response()->json([
//         //     'status'     => 'success',
//         //     'message'    => 'Booking and Cart details stored successfully',
//         //     'lastBooking' => $lastBooking
//         // ], 200);

//         // Insert Order Data
//         $order = OrderModel::create([
//             'booking_id'     => $newbookingId,
//             'encrypt_BookingID' => $encriptedBkID,
//             'unit_no'        => $data['Unit_no'],
//             'session_bid'    => $data['User_Id'],
//             'phone'          => $data['phone_no'],
//             'add_mobile'     => $data['Add_phone_no'] ?? "NA",
//             'uname'          => $data['User_name'] ?? "NA",
//             'total_Amount'   => $data['total_amount'],
//             'Payment_status' => $data['Payment_status'],
//             'payment_mode'   => $data['payment_mode'],
//         ]);

//         // Insert Cart Items in Bulk
//         if (!empty($data['cart'])) {
//             $cartItems = array_map(fn($cartItem) => [
//                 'session_id'        => $data['User_Id'],
//                 'Assign_service_id' => $cartItem['Assign_Service_Id'],
//                 'quantity'          => $cartItem['service_quantity'],
//                 'price'             => $cartItem['Price'],
//                 'total_price'       => $cartItem['Total_price'],
//             ], $data['cart']);

//             CartModel::insert($cartItems);
//         }

//         DB::commit();

//         return response()->json([
//             'status'     => 'success',
//             'message'    => 'Booking and Cart details stored successfully',
//             'booking_id' => $newbookingId,
//             'encrypt_booking_id' => $encriptedBkID
//         ], 200);
//     } catch (\Exception $e) {
//         DB::rollBack();

//         return response()->json([
//             'status'  => 'error',
//             'message' => 'Failed to store booking details',
//             'error'   => $e->getMessage(),
//         ], 500);
//     }
// }

public function initiateBooking(Request $request): JsonResponse
{
    $data = $request->json()->all();

        //   return response()->json([
        //     'status'     => 'success',
        //     'data' => $data
   
        // ], 200);

    try {
        DB::beginTransaction();

        // Generate Unique Booking ID
        $currentYear = date('Y');
        $currentMonth = date('m');

        $lastBooking = OrderModel::where('booking_id', 'LIKE', "B{$currentYear}{$currentMonth}%")
            ->orderBy('id', 'desc')
            ->first();

        $lastNumber = $lastBooking && preg_match('/B\d{6}(\d+)/', $lastBooking->booking_id, $matches)
            ? (int)$matches[1]
            : 0;

        $nextNumber = $lastNumber + 1;
        $numberLength = max(6, strlen($nextNumber));
        $newbookingId = "B" . $currentYear . $currentMonth . str_pad($nextNumber, $numberLength, '0', STR_PAD_LEFT);

       
        $encriptedBkID = strtoupper(substr(hash('sha256', $newbookingId), 0, 16));

        // return response()->json([
        //     'status'     => 'success',
        //     'message'    => 'Booking and Cart details stored successfully',
        //     'lastBooking' => $lastBooking
        // ], 200);

        // Insert Order Data
        $order = OrderModel::create([
            'booking_id'     => $newbookingId,
            'encrypt_BookingID' => $encriptedBkID,
            'unit_no'        => $data['Unit_no'],
            'session_bid'    => $data['User_Id'],
            'phone'          => $data['phone_no'],
            'add_mobile'     => $data['Add_phone_no'] ?? "NA",
            'uname'          => $data['User_name'] ?? "NA",
            'total_Amount'   => $data['total_amount'],
            'Payment_status' => $data['Payment_status'],
            'payment_mode'   => $data['payment_mode'],
        ]);

        // Insert Cart Items in Bulk
        if (!empty($data['cart'])) {
            $cartItems = array_map(fn($cartItem) => [
                'session_id'        => $data['User_Id'],
                'Assign_service_id' => $cartItem['Assign_Service_Id'],
                'quantity'          => $cartItem['service_quantity'],
                'price'             => $cartItem['Price'],
                'total_price'       => $cartItem['Total_price'],
            ], $data['cart']);

            CartModel::insert($cartItems);
        }

        DB::commit();

        return response()->json([
            'status'     => 'success',
            'message'    => 'Booking and Cart details stored successfully',
            'booking_id' => $newbookingId,
            'encrypt_booking_id' => $encriptedBkID
        ], 200);
    } catch (\Exception $e) {
        DB::rollBack();

        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to store booking details',
            'error'   => $e->getMessage(),
        ], 500);
    }
}



    public function paymentSuccessbooking(Request $request): JsonResponse
{
    $data = $request->json()->all();

        //       return response()->json([
        //     'status'     => 'success',
        //     'data' => $order->add_mobile
   
        // ], 200);


    try {
        DB::beginTransaction();

        $userId         = $data['userId'];
        $bookingId      = $data['bookingId'];
        $paymentStatus  = $data['Payment_status'];
        $referenceId    = $data['provider_reference_id'];
        $checkSum       = $data['check_sum'];
        $receiptUrl     = "https://testenv.magnetconnects.com/Payment-Receipt/{$bookingId}";
        
        // Fetch the Order
        $order = OrderModel::where('booking_id', $bookingId)->firstOrFail();

        // Update Payment Status
        $order->updateOrFail([
            'Payment_status'         => $paymentStatus,
            'provider_reference_id'  => $referenceId,
            'check_sum'              => $checkSum,
        ]);

        // Fetch Cart Items for the User
        $cartItems = CartModel::where('session_id', $userId)->get();

        if ($cartItems->isNotEmpty()) {
            $bookingItems = $cartItems->map(fn($cartItem) => [
                'booking_id'        => $bookingId,
                'assign_service_id' => $cartItem->Assign_service_id,
                'qnty'              => $cartItem->quantity,
                'price'             => $cartItem->price,
                'total_price'       => $cartItem->total_price,
            ])->toArray();

            // Insert into Booking Items
            BookingItemModel::insert($bookingItems);

            // Clear Cart
            CartModel::where('session_id', $userId)->delete();
        }

     
         $this->sendSms($order->phone, "Dear Customer,  
Your booking $bookingId is successful. 
You can view your payment details: $receiptUrl.

- Team mFresh by MagnetConnects");


       if ($order->add_mobile !== "NA") {

    $this->sendSms($order->add_mobile, "Dear Customer,  
Your booking $bookingId is successful. 
You can view your payment details: $receiptUrl.

- Team mFresh by MagnetConnects");


       }

        DB::commit();

        return response()->json([
            'status'  => 'success',
            'message' => 'Payment confirmed, booking status updated, and cart items moved to booking items',
            'encrypt_bking_id' => $order->encrypt_BookingID,
            'AccessDate'       => $order->created_at
        ], 200);

    } catch (\Exception $e) {
        DB::rollBack();

        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to update booking details',
            'error'   => $e->getMessage(),
        ], 500);
    }
}




// public function sendSms($phone, $message)
// {

//     //  dd($message);
//     $apikey = '676933437ed08';
//     $senderid = 'MCVPL';
//     $encodedText = urlencode($message);
//     // dd($encodedText);
//     // $apiUrl = "https://www.smsalert.co.in/api/push.json?apikey=$apikey&sender=$senderid&mobileno=$phone&text=$encodedText";
//     $phone="6370658717";
//      $apiUrl = "https://www.smsalert.co.in/api/push.json?apikey=$apikey&sender=$senderid&mobileno=$phone&text=$encodedText&shortenurl=1";
    
//     $response = file_get_contents($apiUrl); 
// }

// function sendSms($phone, $message) {
//     return 'hii';
//     $apikey   = '676933437ed08';
//     $senderid = 'MAGCON';
//     $url      = "https://www.smsalert.co.in/api/push.json";

//     $postData = [
//         'apikey'     => $apikey,
//         'sender'     => $senderid,
//         'mobileno'   => $phone,
//         'text'       => $message,
//         'shortenurl' => 1,
//     ];

//     $ch = curl_init();
//     curl_setopt_array($ch, [
//         CURLOPT_URL => $url,
//         CURLOPT_POST => true,
//         CURLOPT_POSTFIELDS => http_build_query($postData),
//         CURLOPT_RETURNTRANSFER => true,
//         CURLOPT_TIMEOUT => 3,
//     ]);
//     $response = curl_exec($ch);
//     if (curl_errno($ch)) {
//         return "cURL Error: " . curl_error($ch);
//     }
//     curl_close($ch);
//       return response()->json([
//             'status'  => 'error',
//             'message' => $response,
//         ], 500);
//     return $response;
// }

function sendSms($phone, $message)
{
    // Log::info("SEND_SMS_CALLED", ['phone' => $phone]);

    $apikey   = '686e44785ca27';
    $senderid = 'MAGCON';
    $url      = "https://www.smsalert.co.in/api/push.json";

    // sanitize number
    $phone = preg_replace('/\D/', '', $phone);

    $postData = [
        'apikey'     => $apikey,
        'sender'     => $senderid,
        'mobileno'   => $phone,
        'text'       => $message,
        'shortenurl' => 1,
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($postData),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        Log::error("SMS CURL ERROR: " . curl_error($ch));
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    // Log::info("SMS_RESPONSE", [$response]);

    return $response;
}


public function customerbookinghistory(Request $request)
{
    try {
        $user = auth('customer')->user();

        if (!$user) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Session expired or you are logged out. Please log in again.',
                'data'    => []
            ], 401);
        }

        $bookingDetails = OrderModel::select(
            'booking_tbl.booking_id',
            'booking_tbl.unit_no',
            'booking_tbl.created_at',
            'booking_tbl.qr_code',
            'booking_item.qnty',
            'booking_tbl.total_amount',
            'booking_tbl.payment_mode',
            'servises.services_name',
            'servises.img_icon',
            'servisesqr.unit_location',
            'state_service.state_name',
            'district_srvice.district_name',
            'servisesqr.full_add',
            'booking_tbl.encrypt_BookingID'
        )
        ->join('booking_item', 'booking_tbl.booking_id', '=', 'booking_item.booking_id')
            ->join('assignservice', 'booking_item.assign_service_id', '=', 'assignservice.id')
            ->join('servises', 'assignservice.serviceId', '=', 'servises.id')            
		
        ->join('servisesqr', 'booking_tbl.unit_no', '=', 'servisesqr.qrcodeId')
        ->join('state_service', 'servisesqr.state_id', '=', 'state_service.id')
        ->join('district_srvice', 'servisesqr.district_id', '=', 'district_srvice.id')
        ->where('booking_tbl.phone', '=', $user->mob)
        ->orderBy('booking_tbl.id', 'desc')
        ->get()
        ->groupBy('booking_id');

        if ($bookingDetails->isEmpty()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'No booking history found.',
                'data'    => []
            ], 404);
        }

        $transformedBookingDetails = $bookingDetails->map(function ($items) {
            $first = $items->first();
            return [
                'booking_id'    => $first->booking_id,
                'encrypt_booking_id'  => $first->encrypt_BookingID,
                'unit_no'       => $first->unit_no,
                'created_at'    => $first->created_at->timezone('Asia/Kolkata')->format('Y-m-d H:i:s'),
                'total_amount'  => $first->total_amount,
                'payment_mode'  => $first->payment_mode,
            ];
        })->toArray();

        return response()->json([
            'status'  => 'success',
            'message' => 'Booking history retrieved successfully.',
            'data'    => $transformedBookingDetails
        ], 200);

    } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Invalid token. Please log in again.',
            'data'    => []
        ], 401);
    } catch (\Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Token has expired. Please log in again.',
            'data'    => []
        ], 401);
    } catch (\Exception $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong. Please try again later.',
            'error'   => $e->getMessage()
        ], 500);
    }
}




// public function customerbookinghistory(Request $request)
// {
//     try {
//         $user = auth('customer')->user();

//         if (!$user) {
//             return response()->json([
//                 'status'  => 'error',
//                 'message' => 'Session expired or you are logged out. Please log in again.',
//                 'data'    => []
//             ], 401);
//         }

//         $bookingDetails = OrderModel::select(
//             'booking_tbl.booking_id',
//             'booking_tbl.unit_no',
//             'booking_tbl.created_at',
//             'booking_tbl.qr_code',
//             'booking_item.qnty',
//             'booking_tbl.total_amount',
//             'booking_tbl.payment_mode',
//             'servises.services_name',
//             'servises.img_icon',
//             'servisesqr.unit_location',
//             'state_service.state_name',
//             'district_srvice.district_name',
//             'servisesqr.full_add',
//             'booking_tbl.encrypt_BookingID'
//         )
//         ->join('booking_item', 'booking_tbl.booking_id', '=', 'booking_item.booking_id')
//             ->join('assignservice', 'booking_item.assign_service_id', '=', 'assignservice.id')
//             ->join('servises', 'assignservice.serviceId', '=', 'servises.id')            
		
//         ->join('servisesqr', 'booking_tbl.unit_no', '=', 'servisesqr.qrcodeId')
//         ->join('state_service', 'servisesqr.state_id', '=', 'state_service.id')
//         ->join('district_srvice', 'servisesqr.district_id', '=', 'district_srvice.id')
//         ->where('booking_tbl.phone', '=', $user->mob)
//         ->orderBy('booking_tbl.id', 'desc')
//         ->get()
//         ->groupBy('booking_id');

//         if ($bookingDetails->isEmpty()) {
//             return response()->json([
//                 'status'  => 'error',
//                 'message' => 'No booking history found.',
//                 'data'    => []
//             ], 404);
//         }

//         $transformedBookingDetails = $bookingDetails->map(function ($items) {
//             $first = $items->first();
//             return [
//                 'booking_id'    => $first->booking_id,
//                 'encrypt_booking_id'  => $first->encrypt_BookingID,
//                 'unit_no'       => $first->unit_no,
//                 'created_at'    => $first->created_at,
//                 'total_amount'  => $first->total_amount,
//                 'payment_mode'  => $first->payment_mode,
//             ];
//         })->toArray();

//         return response()->json([
//             'status'  => 'success',
//             'message' => 'Booking history retrieved successfully.',
//             'data'    => $transformedBookingDetails
//         ], 200);

//     } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
//         return response()->json([
//             'status'  => 'error',
//             'message' => 'Invalid token. Please log in again.',
//             'data'    => []
//         ], 401);
//     } catch (\Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {
//         return response()->json([
//             'status'  => 'error',
//             'message' => 'Token has expired. Please log in again.',
//             'data'    => []
//         ], 401);
//     } catch (\Exception $e) {
//         return response()->json([
//             'status'  => 'error',
//             'message' => 'Something went wrong. Please try again later.',
//             'error'   => $e->getMessage()
//         ], 500);
//     }
// }
	
	public function customerbookingdetailshistory(Request $request)
{
    try {
        $user = auth('customer')->user();

        if (!$user) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Session expired or you are logged out. Please log in again.',
                'data'    => []
            ], 401);
        }

        $bookingDetails = OrderModel::select(
            'booking_tbl.booking_id',
            'booking_tbl.unit_no',
            'booking_tbl.created_at',
            'booking_tbl.qr_code',
            'booking_item.qnty',
            'booking_tbl.total_amount',
            'booking_tbl.payment_mode',
            'servises.services_name',
            'servises.img_icon',
            'servisesqr.unit_location',
            'state_service.state_name',
            'district_srvice.district_name',
            'servisesqr.full_add'
        )
        ->join('booking_item', 'booking_tbl.booking_id', '=', 'booking_item.booking_id')
        ->join('assignservice', 'booking_item.assign_service_id', '=', 'assignservice.id')
        ->join('servises', 'assignservice.serviceId', '=', 'servises.id')
        ->join('servisesqr', 'booking_tbl.unit_no', '=', 'servisesqr.qrcodeId')
        ->join('state_service', 'servisesqr.state_id', '=', 'state_service.id')
        ->join('district_srvice', 'servisesqr.district_id', '=', 'district_srvice.id')
        ->where('booking_tbl.booking_id', '=', $request->booking_id)
        ->orderBy('booking_tbl.id', 'desc')
        ->get();

        if ($bookingDetails->isEmpty()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'No booking history found.',
                'data'    => []
            ], 404);
        }

        $grouped = $bookingDetails->groupBy('booking_id');

        $transformedBookingDetails = $grouped->map(function ($items) {
            $first = $items->first();
            return [
                'booking_id'        => $first->booking_id,
                'unit_no'           => $first->unit_no,
                'booking_time_date' => $first->created_at,
                'unit_location'     => $first->unit_location,
                'total_amount'      => $first->total_amount,
                'payment_mode'      => $first->payment_mode,
                'service_icon'      => $first->img_icon,
                'fullAddress'       => $first->full_add,
                'services'          => $items->map(function ($item) {
                    return [
                        'services_name' => $item->services_name,
                        'quantity'      => $item->qnty,
                    ];
                })->toArray(),
            ];
        })->values(); // convert to simple array (numeric keys)

        return response()->json([
            'status'  => 'success',
            'message' => 'Booking details retrieved successfully.',
            'data'    => $transformedBookingDetails
        ], 200);

    } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Invalid token. Please log in again.',
            'data'    => []
        ], 401);
    } catch (\Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Token has expired. Please log in again.',
            'data'    => []
        ], 401);
    } catch (\Exception $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong. Please try again later.',
            'error'   => $e->getMessage()
        ], 500);
    }
}


public function customerbookingdetailshistoryold(Request $request)
{
    try {
        $user = auth('customer')->user();

        if (!$user) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Session expired or you are logged out. Please log in again.',
                'data'    => []
            ], 401);
        }

        $bookingDetails = OrderModel::select(
            'booking_tbl.booking_id',
            'booking_tbl.unit_no',
            'booking_tbl.created_at',
            'booking_tbl.qr_code',
            'booking_item.qnty',
            'booking_tbl.total_amount',
            'booking_tbl.payment_mode',
            'servises.services_name',
            'servises.img_icon',
            'servisesqr.unit_location',
            'state_service.state_name',
            'district_srvice.district_name',
            'servisesqr.full_add'
        )
        ->join('booking_item', 'booking_tbl.booking_id', '=', 'booking_item.booking_id')
   
			    ->join('assignservice', 'booking_item.assign_service_id', '=', 'assignservice.id')
            ->join('servises', 'assignservice.serviceId', '=', 'servises.id')            
			->join('servisesqr', 'booking_tbl.unit_no', '=', 'servisesqr.qrcodeId')
   
        ->join('state_service', 'servisesqr.state_id', '=', 'state_service.id')
        ->join('district_srvice', 'servisesqr.district_id', '=', 'district_srvice.id')
        ->where('booking_tbl.booking_id', '=', $request->booking_id)
        ->orderBy('booking_tbl.id', 'desc')
        ->get()
        ->groupBy('booking_id');

        if ($bookingDetails->isEmpty()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'No booking history found.',
                'data'    => []
            ], 404);
        }

        $transformedBookingDetails = $bookingDetails->map(function ($items) {
            $first = $items->first();
            return [
                'booking_id'    => $first->booking_id,
                'unit_no'       => $first->unit_no,
                'booking_time_date'    => $first->created_at->timezone('Asia/Kolkata')->format('Y-m-d H:i:s'),
                'unit_location' => $first->unit_location,
                'total_amount'  => $first->total_amount,
                'payment_mode'  => $first->payment_mode,
                'service_icon'  => $first->img_icon,
                'fullAddress'   => $first->full_add,
                'services'      => $items->map(function ($item) {
                    return [
                        'services_name' => $item->services_name,
                        'quantity'      => $item->qnty,
                    ];
                })->toArray(),
            ];
        })->toArray();

        return response()->json([
            'status'  => 'success',
            'message' => 'Booking Deatails retrieved successfully.',
            'data'    => $transformedBookingDetails
        ], 200);

    } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Invalid token. Please log in again.',
            'data'    => []
        ], 401);
    } catch (\Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Token has expired. Please log in again.',
            'data'    => []
        ], 401);
    } catch (\Exception $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong. Please try again later.',
            'error'   => $e->getMessage()
        ], 500);
    }
}
	

   public function getStates(): JsonResponse
    {

        try {
            $states = StateAdminModel::select('id', 'state_name')->get();

            return response()->json([
                'status' => 'success',
                'message' => 'States retrieved successfully',
                'data' => $states
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    // 2️⃣ Get districts by state
    public function getDistricts(Request $request): JsonResponse
    {
        $request->validate([
            'state' => 'required|string'
        ]);

        try {
            $districts = ServiceQrModel::where('state', $request->state)
                ->select('district')
                ->distinct()
                ->pluck('district');

            return response()->json([
                'status' => 'success',
                'message' => 'Districts retrieved successfully',
                'data' => $districts
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    // 3️⃣ Get units filtered by state, district, and optional unit number
    public function getUnits(Request $request): JsonResponse
    {
        $request->validate([
            'state' => 'nullable|string',
            'district' => 'nullable|string',
            'unit_no' => 'nullable|string',
        ]);

        try {
            $query = ServiceQrModel::query();

            if ($request->filled('state')) {
                $query->where('state', $request->state);
            }
            if ($request->filled('district')) {
                $query->where('district', $request->district);
            }
            if ($request->filled('unit_no')) {
                $query->where('qrcodeId', $request->unit_no);
            }

            $units = $query->select('id', 'qrcodeId', 'unit_img', 'unit_location', 'open_timing')->get();

            if ($units->isEmpty()) {
                return response()->json([
                    'status' => 'success',
                    'message' => 'No units found',
                    'data' => []
                ]);
            }

            $result = [];
            foreach ($units as $unit) {
                $result[] = [
                    'Id' => $unit->id,
                    'Unit_Id' => $unit->qrcodeId,
                    'Unit_Image' => $unit->unit_img,
                    'Unit_location' => $unit->unit_location,
                    'timming' => $unit->open_timing,
                ];
            }

            return response()->json([
                'status' => 'success',
                'message' => 'Units retrieved successfully',
                'data' => $result
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',
                'error' => $e->getMessage()
            ], 500);
        }
    }


    public function Payment_fail_delete_cart(Request $request)
{
    // return 'hii';
    try {
   
 
        $userID = $request->userID;

     
        $cartItems = CartModel::where('session_id', $userID)->get();
        //   return response()->json([
        //     'status' => $cartItems
        // ], 500);
        

        if ($cartItems->isEmpty()) {
            return response()->json([
                'status' => false,
                'message' => 'No cart items found for this user.'
            ], 404);
        }

        // Delete all cart items for that session_id
        CartModel::where('session_id', $userID)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Cart items deleted successfully.'
        ], 200);

    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => 'Something went wrong: ' . $e->getMessage()
        ], 500);
    }
}


public function validateMemberPhone(Request $request)
{
 

    $phone = trim($request->phone);



    $customer = CustomerModel::where('mob', $phone)->first();
    if (!$customer) {
        return response()->json([
            'status' => 'error',
            'type' => 'not_found',
            'message' => 'No member found with this phone number.'
        ], 404);
    }

    $membership = MembershipCustomerModel::where('customer_id', $customer->id)->first();
    if (!$membership) {
        return response()->json([
            'status' => 'error',
            'type' => 'no_membership',
            'message' => 'This member does not have an active membership.'
        ], 403);
    }

    $validTill = Carbon::parse($membership->created_at)
        ->addMonths($membership->validity);

    if (now()->greaterThan($validTill)) {
        return response()->json([
            'status' => 'error',
            'type' => 'expired',
            'message' => 'Membership expired on ' . $validTill->format('d-m-Y')
        ], 403);
    }

    return response()->json([
        'status' => 'valid',
        'message' => 'Member is valid. Proceed to OTP.',
        'customer_id' => $customer->id,
        'phone' => $phone
    ]);
}

public function memsendOtp(Request $request)
{
    $request->validate([
        'phone' => 'required|digits:10'
    ]);

    $mobile = $request->phone;
    $otp = rand(100000, 999999);

    /**
     * STEP 1: Clear old OTP for this number
     */
    otpmodel::where('phone', $mobile)->delete();

    /**
     * STEP 2: Store OTP in DB (valid for 5 minutes)
     */
    otpmodel::create([
        'phone' => $mobile,
        'otp' => $otp,
        'expires_at' => Carbon::now()->addMinutes(5)
    ]);

    /**
     * STEP 3: Prepare SMS
     */
    $message = "$otp is your One Time Verification(OTP) to confirm your phone no. at MagnetConnects Venture Private Limited";
    $encodedMessage = urlencode($message);

    $apiKey = '686e44785ca27';
    $senderId = 'MCVPL';

    /**
     * STEP 4: Send SMS using cURL
     */
    $url = "https://www.smsalert.co.in/api/push.json";
    $params = "apikey=$apiKey&sender=$senderId&mobileno=$mobile&text=$encodedMessage";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    /**
     * STEP 5: Handle SMS failure
     */
    if ($httpCode != 200 || !$response) {
        return response()->json([
            'status' => 'error',
            'message' => 'OTP sending failed',
            'sms_response' => $response
        ], 500);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'OTP sent successfully',
        'expires_in' => 300 // seconds
    ]);
}

public function memverifyOtp(Request $request)
{


    // STEP 1: Fetch OTP record
    $otpRecord = otpmodel::where('phone', $request->phone)
        ->where('otp', $request->otp)
        ->first();

    // STEP 2: OTP not found
    if (!$otpRecord) {
        return response()->json([
            'status' => 'error',
            'message' => 'Invalid OTP'
        ], 422);
    }

    // STEP 3: Check expiry
    if (Carbon::now()->greaterThan($otpRecord->expires_at)) {
        $otpRecord->delete(); // expired OTP clear

        return response()->json([
            'status' => 'error',
            'message' => 'OTP expired'
        ], 422);
    }

    // STEP 4: OTP verified (one-time use)
    $otpRecord->delete();

    return response()->json([
        'status' => 'success',
        'message' => 'OTP verified successfully'
    ]);
}




}
