<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderModel extends Model
{
    use HasFactory;
    protected $table = 'booking_tbl';
    public $timestamps = true;
    protected $guarded = [];

    public function serviceQr()
    {
        return $this->hasOne(ServiceQrModel::class, 'qrcodeId', 'unit_no');  // Linking unit_no with qrcodeId
    }

    public function bookingItems()
    {
        return $this->hasMany(BookingItemModel::class, 'booking_id', 'booking_id');
      
    }
}
